/* 
Copyright Paul James Mutton, 2001-2003, http://www.jibble.org/

This file is part of PircBot.

You may freely use PircBot to make your own IRC bots and clients.

Any software that makes use of the PircBot package must clearly
state that it makes use of the PircBot Java IRC Bot Framework (or
some similar wording) found at http://www.jibble.org/

This source code, or parts thereof, may not be distributed in any
modified form without permission from the author.

PircBot is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

package org.jibble.pircbot;

/**
 * The Colors class provides several static fields that you may
 * find useful when writing an IRC Bot.
 *  <p>
 * This class contains constants that are useful for formatting lines
 * sent to IRC servers.  These constants allow you to apply various
 * formatting to the lines, such as colours, boldness, underlining
 * and reverse text.
 *  <p>
 * Here are some examples of how to use these contants from within a
 * class that extends PircBot and imports org.jibble.pircbot.*;
 * 
 * <pre> sendMessage("#cs", Colors.BOLD + "A bold hello!");
 *     <b>A bold hello!</b>
 * sendMessage("#cs", Colors.RED + "Red" + Colors.NORMAL + " text");
 *     <font color="red">Red</font> text
 * sendMessage("#cs", Colors.BOLD + Colors.RED + "Bold and red");
 *     <b><font color="red">Bold and red</font></b></pre>
 * 
 * Please note that some IRC channels may be configured to reject any
 * messages that use colours.  Also note that older IRC clients may be
 * unable to correctly display lines that contain colours and other
 * control characters.
 *  <p>
 * Note that this class name has been spelt in the American style in
 * order to remain consistent with the rest of the Java API.
 *
 *
 * @since   0.9.12
 * @author  Paul James Mutton,
 *          <a href="http://www.jibble.org/">http://www.jibble.org/</a>
 * @version    1.0.5 (Build time: Sat Apr 26 23:11:37 2003)
 */
public class Colors {

    
    /**
     * Removes all previously applied color and formatting attributes.
     */
    public static final String NORMAL = "\u000f";


    /**
     * Bold text.
     */
    public static final String BOLD = "\u0002";
    

    /**
     * Underlined text.
     */
    public static final String UNDERLINE = "\u001f";


    /**
     * Reversed text (may be rendered as italic text in some clients).
     */
    public static final String REVERSE = "\u0016";
    

    /**
     * White coloured text.
     */
    public static final String WHITE = "\u000300";
    

    /**
     * Black coloured text.
     */
    public static final String BLACK = "\u000301";
    

    /**
     * Dark blue coloured text.
     */
    public static final String DARK_BLUE = "\u000302";
    

    /**
     * Dark green coloured text.
     */
    public static final String DARK_GREEN = "\u000303";
    

    /**
     * Red coloured text.
     */
    public static final String RED = "\u000304";
    

    /**
     * Brown coloured text.
     */
    public static final String BROWN = "\u000305";
    

    /**
     * Purple coloured text.
     */
    public static final String PURPLE = "\u000306";
    

    /**
     * Olive coloured text.
     */
    public static final String OLIVE = "\u000307";
    

    /**
     * Yellow coloured text.
     */
    public static final String YELLOW = "\u000308";
    

    /**
     * Green coloured text.
     */
    public static final String GREEN = "\u000309";
    

    /**
     * Teal coloured text.
     */
    public static final String TEAL = "\u000310";
    

    /**
     * Cyan coloured text.
     */
    public static final String CYAN = "\u000311";
    

    /**
     * Blue coloured text.
     */
    public static final String BLUE = "\u000312";
    

    /**
     * Magenta coloured text.
     */
    public static final String MAGENTA = "\u000313";
    

    /**
     * Dark gray coloured text.
     */
    public static final String DARK_GRAY = "\u000314";
    

    /**
     * Light gray coloured text.
     */
    public static final String LIGHT_GRAY = "\u000315";

    
    /**
     * This class should not be constructed.
     */
    private Colors() {
        
    }
    
}
